# načteme celý textový soubor do paměti jako seznam jednotlivých řádek
with open('filmy_1.csv', mode='tr', encoding='utf-8') as soubor:
    řádky = soubor.readlines()

# vyrobíme nový seznam, ve kterém budou řádky upravené:
# 
# "1;Harry Potter and the Philosopher's Stone;2001;Chris Columbus"
#  =>
# "Philosopher's Stone;2001;Chris Columbus"
# ...
# "7b;Harry Potter and the Deathly Hallows – Part 2;2011;David Yates"
#  =>
# "Deathly Hallows – Part 2;2011;David Yates"
#
# ~ zde úmyslně ořežeme všechny řádky stejně => " Deathly Hallows" budou začínat na mezeru
data = []
for řádka in řádky:
    data.append(řádka[23:])
print(data)     # zde je ta mezera vidět

# vypíšeme prvky seznamu (upravené řádky) seřazené podle abecedy
for řádka in sorted(data):
    print(řádka.rstrip())    # .rstrip() odstraní pouze '\n' na konci
